addpath('../3dParty/mtimesx/');

clear

useCA_CCRF = true;

% Check if parallel toolbox is present, and if GPU is supported, if so use
% it
useGPU = false;

v = ver;
% if(any(strcmp('Parallel Computing Toolbox', {v.Name})))
%     % need a GPU test here
%     try
%         g = gpuDevice;
%         if(gpuDevice.DeviceSupported)
%             useGPU = true;
%         else
%            fprintf('Gpu device not supported will not use gpu acceleration\n'); 
%         end
%     catch err
%         fprintf('Cannot locate a gpu device will not use gpu acceleration\n');
%     end
% end

% set up the lambda ranges to check
% lambdas_a_range = 0:2:8;
% lambdas_b_range = 0:2:8;
lambdas_a_range = -2:2:6;
lambdas_b_range = -2:2:6;

lambdas_a = 10.^(lambdas_a_range);
lambdas_b = 10.^(lambdas_b_range);

for dim=1:4
   for fold=1:10
      crossvalidate_ca_ccrf_lambdas_grad_desc(dim, lambdas_a, lambdas_b, fold, useCA_CCRF, useGPU);
   end
end

%% training and testing
[lambda_a, lambda_b] = getRegularisationResults('CA_CCRF');

%
evaluate_CCRF_grad_desc(lambda_a, lambda_b, useCA_CCRF, 'CA_CCRF_res.mat');